/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClient;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletClientPortal;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletMessage;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.impl.CommManager;
import com.ibm.hwmca.fw.rbf.impl.RbfInternalConstants;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RbfChatletClient
implements ChatletClient,
RbfInternalConstants {
    private static final String TRACE_MASKT = "XRBFCHCT";
    private static final String TRACE_MASKF = "XRBFCHCF";
    private static final String TRACE_MASKD = "XRBFCHCD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-ChatClnt");
    private static final String CHATLET_CLASSNAME = "com.ibm.hwmca.fw.rbf.impl.RbfChatlet";
    private MachineId target;
    private ChatletClientPortal portal;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rbf$impl$RbfReply;

    public RbfChatletClient(MachineId target) {
        if (target == null) {
            throw new IllegalArgumentException("Null target specified");
        }
        this.target = target;
        String targetInfo = RbfUtils.getMachineInfo(target);
        Trace.trace(TRACE_MASKT, "<> RbfChatletClient(" + targetInfo + ")");
    }

    public String getRemoteChatletClass() {
        return CHATLET_CLASSNAME;
    }

    public void setChatletClientPortal(ChatletClientPortal portal) {
        Trace.trace(TRACE_MASKT, "-> setChatletClientPortal()");
        this.portal = portal;
        Trace.trace(TRACE_MASKT, "<- setChatletClientPortal()");
    }

    public void asynchronousMessage(ChatletMessage message) {
        Trace.trace(TRACE_MASKT, "-> asynchronousMessage()");
        Trace.trace(TRACE_MASKT, "<- asynchronousMessage()");
    }

    public void destroy() {
        Trace.trace(TRACE_MASKT, "-> destroy()");
        CommManager commMgr = CommManager.getCommManager();
        commMgr.removeChatletClient(this);
        Trace.trace(TRACE_MASKT, "<- destroy()");
    }

    public MachineId getTarget() {
        return this.target;
    }

    public void setTarget(MachineId target) {
        this.target = target;
    }

    RbfReply sendMsg(RbfMsg msg, int soTimeout, int protocol) throws RbfException {
        Trace.trace(TRACE_MASKT, "-> sendMsg(" + soTimeout + ", " + protocol + ")");
        Object reply = null;
        String targetInfo = RbfUtils.getMachineInfo(this.target);
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        Trace.trace(TRACE_MASKF, "target=" + targetInfo + ", protocol=" + protocol);
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(msg);
            oos.flush();
            byte[] msgBytes = baos.toByteArray();
            ChatletRequest request = new ChatletRequest();
            request.setProperty("Protocol", new Integer(protocol));
            request.setProperty("Message", msgBytes);
            Trace.trace(TRACE_MASKF, "Outgoing " + msg);
            ChatletResponse response = this.portal.sendRequest(request, soTimeout);
            int commonProtocol = -1;
            Integer responseProtocol = (Integer)response.getProperty("Protocol");
            if (responseProtocol != null) {
                commonProtocol = responseProtocol;
                if (commonProtocol == -1) {
                    String desc = "Version " + protocol + " unsupported by target";
                    Trace.trace(TRACE_MASKF, desc);
                    throw new RbfException(desc);
                }
            } else {
                String desc = "No protocol in chatlet response from " + targetInfo;
                Trace.trace(TRACE_MASKF, desc);
                RbfException rbfe = new RbfException(desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060, rbfe);
                fl.add(RbfUtils.getLoggingInfo());
                fl.log();
                throw rbfe;
            }
            byte[] replyBytes = (byte[])response.getProperty("Reply");
            if (replyBytes == null) {
                String desc = "No reply in chatlet response from " + targetInfo + ", expected " + (class$com$ibm$hwmca$fw$rbf$impl$RbfReply == null ? (class$com$ibm$hwmca$fw$rbf$impl$RbfReply = RbfChatletClient.class$("com.ibm.hwmca.fw.rbf.impl.RbfReply")) : class$com$ibm$hwmca$fw$rbf$impl$RbfReply).getName();
                Trace.trace(TRACE_MASKF, desc);
                RbfException rbfe = new RbfException(desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060, rbfe);
                fl.add(RbfUtils.getLoggingInfo());
                fl.log();
                throw rbfe;
            }
            bais = new ByteArrayInputStream(replyBytes);
            ois = new ObjectInputStream(bais);
            reply = ois.readObject();
            String desc = "Incoming " + reply + "\n" + "sender=" + targetInfo + ", protocol=" + protocol;
            Trace.trace(TRACE_MASKF, desc);
            if (!(reply instanceof RbfReply)) {
                desc = "Unexpected reply " + reply.getClass().getName() + " from " + targetInfo + ", expected " + (class$com$ibm$hwmca$fw$rbf$impl$RbfReply == null ? (class$com$ibm$hwmca$fw$rbf$impl$RbfReply = RbfChatletClient.class$("com.ibm.hwmca.fw.rbf.impl.RbfReply")) : class$com$ibm$hwmca$fw$rbf$impl$RbfReply).getName();
                Trace.trace(TRACE_MASKF, desc);
                RbfException rbfe = new RbfException(desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060, rbfe);
                fl.add(RbfUtils.getLoggingInfo());
                fl.log();
                throw rbfe;
            }
            ((RbfReply)reply).process(this.target, commonProtocol);
        }
        catch (Exception e) {
            if (e instanceof RbfException) {
                throw (RbfException)e;
            }
            Trace.trace(TRACE_MASKF, e.getClass().getName() + " sending " + msg.getClass().getName() + " to " + targetInfo + ":\n " + RbfUtils.getStackTrace(e));
            throw new RbfException(e);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
                if (oos != null) {
                    oos.close();
                }
                if (bais != null) {
                    bais.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e2) {}
        }
        Trace.trace(TRACE_MASKT, "<- sendMsg()");
        return (RbfReply)reply;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

